﻿$(document).ready(function () {
    $(".v-selectProject #ProjectName").a4autocomplete({
        ajaxAction: a4.getAction("GetProjectsForAutocomplete", "Home", "Project"),
        ajaxParams: { ignoreProject: $("#HideProjectId").val(), showRoleOnly: $("#ShowRoleOnly").val() },
        valueProperty: "Id",
        labelProperty: "Name",
        categoryProperty: "FolderName",
        select: function () {
            $(".v-selectProject #ProjectName").removeClass("input-validation-error");
            $(".v-selectProject .field-validation-error").hide();
        }
    });

    $(".v-selectProject").on("click", ".v-confirmButton", function () {
        var selectedProject = $(".v-selectProject #ProjectName").a4autocomplete("getValue");
        var confirmDialogResources = _.unescape($(".v-selectProject #ConfirmDialogResources").val());

        if (!selectedProject || !selectedProject.Id)
        {
            var errorMessage = $(".v-selectProject #ProjectName").attr("data-val-required");
            $(".v-selectProject #ProjectName").addClass("input-validation-error");
            $(".v-selectProject .field-validation-valid").addClass("field-validation-error");
            $(".v-selectProject .field-validation-valid").html(errorMessage);
            $(".v-selectProject .field-validation-valid").show();
        }
        else
        {
            var finalizeSelection = function () {
                a4.top().selectedProjectId = selectedProject.Id;
                modalDialog.close();
            };

            if (!confirmDialogResources)
            {
                finalizeSelection();
            }
            else
            {
                var dialogResources = JSON.parse(confirmDialogResources);

                if (dialogResources)
                    modalDialog.showConfirmDialog(dialogResources, function () { finalizeSelection(); }, null, null, true);
                else
                    finalizeSelection();
            }
        }
    });
});